
	include	exec/exec_lib.i
	include dos/dos_lib.i
	include graphics/graphics_lib.i
	include	intuition/intuition_lib.i
	include	libraries/reqtools_lib.i
	include	newcustomreg
	bsr	getmemory
	tst.l	d0
	beq.s	end
	bsr	init
	bsr	start
	rts
end:
	rts
init:
	bsr.w	task_find
	bsr.w	intlib_open
	bsr.w	gfxlib_open
	bsr.w	doslib_open
	bsr.w	screen_open
	bsr.w	window_open
;	bsr.w	con_open
	bsr.s	int_open
	bsr.w	SetInputHandler
	bsr	DoCopWotsit
	rts

int_open:
	move.l	4.w,a6
	lea	COP_IS(pc),a1
	moveq	#5,d0
	jsr	_LVOAddIntServer(a6)
	rts

int_close:
	move.l	4.w,a6
	lea	COP_IS(pc),a1
	moveq	#5,d0
	jsr	_LVORemIntServer(a6)
	rts

DoCopWotsit:
	moveq	#12,d0
	move.l	#$10002,d1
	jsr	_LVOAllocMem(a6)
	move.l	d0,UCopAddy
	beq	qu
	move.l	ScreenHD,a0
	move.l	UCopAddy,64(a0)		; set pointer to usercopperlist
	move.l	GfxBase,a6

	moveq	#0,d0
	moveq	#0,d1
	move.l	UCopAddy,a1
	jsr	_LVOCWait(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)

	move.l	UCopAddy,a1
	move.l	#$86,d0
	move.l	#MyCoplist,d1
	and.l	#$ffff,d1
	jsr	_LVOCMove(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)
	move.l	#$84,d0
	move.l	#MyCopList,d1
	swap	d1
	and.l	#$ffff,d1
	move.l	UCopAddy,a1
	jsr	_LVOCMove(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)
	move.l	#$8a,d0
	moveq	#0,d1
	move.l	UCopAddy,a1
	jsr	_LVOCMove(a6)
	move.l	UCopAddy,a1
	jsr	_LVOCBump(a6)
	move.l	#10000,d0
	move.l	#255,d1
	move.l	UCopAddy,a1
	jsr	_LVOCWait(a6)

	moveq	#24,d1
	move.l	#newcopper,a0
	move.l	a0,a1
	addq.l	#4,a1		;jump x
	add.l	#12,a0		;loop x
.loop
	move.l	a0,d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	add.l	#180,a0
	add.l	#180,a1
	dbra	d1,.loop

	move.l	intbase,a6
	jsr	_LVORemakeDisplay(a6)
	rts

UndoCopWotsit:
	move.l	UCopAddy,a0
	beq.s	.ov1
	lea	44(a1),a0
	move.l	GfxBase,a6
	jsr	_LVOFreeVPortCopLists(a6)
.ov1
	move.l	intbase,a6
	move.l	ScreenHD,a0
	jsr	_LVORemakeDisplay(a6)
	rts	

con_open:
	move.l	#consolname,d1
	move.l	#1005,d2
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,conhandle
	rts

con_close:
	move.l	conhandle,d1
	move.l	dosbase,a6
	jsr	_LVOclose(a6)
	rts
qu:
	move.l	StackSave,a7
	bsr.s	UndoCopWotsit
	bsr.w	ResetInputHandler
	bsr	freememory
;	bsr.s	con_close
	bsr.w	window_close
	bsr.w	screen_close
	bsr.w	int_close
	bsr.w	gfxlib_close
	bsr.w	intulib_close
	bra.w	doslib_close
	

getmemory:
	move.l	#32000,d0		;4 bitplanes
	move.l	#$10002,d1
	move.l	4.w,a6
	jsr	_LVOAllocMem(a6)
	move.l	d0,BPL1address
	beq	Fail
	add.l	#$28,d0
	move.l	d0,BPL2address
	move.l	d0,BM1Addy
	add.l	#$28,d0
	move.l	d0,BPL3address
	add.l	#$28,d0
	move.l	d0,BPL4Address

	move.l	BPL1Address,d0
	move.w	d0,Screen+6
	swap	d0
	move.w	d0,Screen+2

	move.l	BPL2Address,d0
	move.w	d0,Screen+6+8
	swap	d0
	move.w	d0,Screen+2+8

	move.l	BPL3Address,d0
	move.w	d0,Screen+6+16
	swap	d0
	move.w	d0,Screen+2+16

	move.l	BPL4Address,d0
	move.w	d0,Screen+6+24
	swap	d0
	move.w	d0,Screen+2+24

GetFAST:	
	move.l	#262144,d0
	move.l	#$10001,d1
	move.l	4.w,a6
	jsr	_LVOAllocMem(a6)	
	move.l	d0,address
	beq.s	Fail
	move.l	#262144,d0
	move.l	4.w,a6
	move.l	address,a1
	jsr	_LVOFreeMem(a6)
	move.l	address,d0
	add.l	#$10000,d0
	move.w	#0,d0
	move.l	d0,a1
	move.l	#192*1024,d0
	move.l	4.w,a6
	jsr	_LVOAllocAbs(a6)
	move.l	d0,address
	beq.s	GetFAST
Fail:
	rts

freememory:
	move.l	address,a1
	move.l	#192*1024,d0
	move.l	4.w,a6
	jsr	_LVOFreeMem(a6)
	move.l	BPL1address,a1
	move.l	#32000,d0
	move.l	4.w,a6
	jsr	_LVOFreeMem(a6)
	rts

task_find:
	sub.l	a1,a1
	move.l	4.w,a6
	jsr	_LVOfindtask(a6)
	move.l	d0,taskpt
	rts

intlib_open:
	move.l	4.w,a6
	moveq	#0,d0
	lea	intuname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,intbase
	moveq	#0,d0
	lea	RTname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,RTbase
	rts

intulib_close:
	move.l	4.w,a6
	moveq	#0,d0
	move.l	intbase(pc),a1
	jsr	_LVOCloseLibrary(a6)
	bsr	endreq
	rts

doslib_open:
	move.l	4.w,a6
	moveq	#0,d0
	lea	dosname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,dosbase
	rts

doslib_close:
	move.l	4.w,a6
	moveq	#0,d0
	move.l	dosbase(pc),a1
	jsr	_LVOCloseLibrary(a6)
	rts

gfxlib_open:
	move.l	4.w,a6
	moveq	#0,d0
	lea	gfxname(pc),a1
	jsr	_LVOOpenLibrary(a6)
	move.l	d0,gfxbase
	rts

gfxlib_close:
	move.l	4.w,a6
	moveq	#0,d0
	move.l	gfxbase(pc),a1
	jsr	_LVOCloseLibrary(a6)
	rts

screen_open:
	lea.l	screen_defs(pc),a0
	moveq	#0,d0
	move.l	intbase(pc),a6
	jsr	_LVOOpenScreen(a6)
	move.l	d0,screenhd
	rts

screen_close:
	move.l	screenhd(pc),a0
	move.l	intbase(pc),a6
	jsr	_LVOCloseScreen(a6)
	rts

window_open:
	move.l	intbase(pc),a6
	lea	window_defs(pc),a0
	jsr	_LVOOpenWindow(a6)
	move.l	d0,windowhd
	move.l	taskpt(pc),a0
	move.l	$b8(a0),taskoldwin
	move.l	d0,$b8(a0)
	rts

window_close:
	move.l	taskpt(pc),a0
	move.l	taskoldwin(pc),$b8(a0)
	move.l	intbase(pc),a6
	move.l	windowhd(pc),a0
	jsr	_LVOCloseWindow(a6)
	rts

SetInputHandler:
	moveq	#-1,d0
	move.l	4.w,a6
	jsr	_LVOAllocSignal(a6)
	move.l	d0,d2
	move.l	d0,MySig
	sub.l	a1,a1
	jsr	_LVOFindTask(a6)
	move.l	d0,MyTask
	lea	InputEP(pc),a1		;input event port
	move.b	#0,9(a1)		;List Node Priority
	move.l	#0,10(a1)		;List Node Name
	move.b	#4,8(a1)		;NT_MsgPort -> Node Type
	move.b	d2,15(a1)		;MP_SigBit
	move.l	d0,16(a1)		;MP_SigTask
	jsr	_LVOAddPort(a6)
	lea	idevname(pc),a0
	lea	IEIOreq(pc),a1
	moveq	#0,d0
	moveq	#0,d1
	move.l	#InputEP,14(a1)
	jsr	_LVOOpenDevice(a6)
	lea	IEIOreq(pc),a1
	move.w	#9,28(a1)		;IO_Command
	move.b	#1,30(a1)		;IO_Flags
	move.l	#InputEF,40(a1)		;IO_Flags
	jsr	_LVODoIO(a6)
	rts

ResetInputHandler:
	move.l	4.w,a6
	lea	IEIOreq(pc),a1
	move.w	#10,28(a1)		;IO_Command
	move.b	#1,30(a1)		;IO_Flags
	move.l	#InputEF,40(a1)		;IO_Data
	jsr	_LVODoIO(a6)
	lea	IEIOReq(pc),a1
	jsr	_LVOCloseDevice(a6)
	lea	InputEP(pc),a1
	jsr	_LVORemPort(a6)
	move.l	MySig,d0
	jsr	_LVOFreeSignal(a6)
	rts

;InputHandler:
;	move.l	a0,d0
;	cmp.b	#1,4(a0)
;	bne.s	.over
;	movem.l	d0/a6,-(sp)
;	moveq	#0,d0
;	move.w	6(a0),d0
;	cmp.w	#$65,d0
;	bls.s	.ov
;
;	move.w	#-1,KeyCode
;	bra.s	.ov1
;
;.ov	cmp.w	#$45,d0
;	beq.s	.esc
;	move.w	d0,KeyCode
;;	move.w	#1,KeyCode
;	move.w	8(a0),KeyQual
;
;	moveq	#0,d0
;.ov1	movem.l	(sp)+,d0/a6
;.over	rts
;.esc	move.w	#-1,ISData
;	moveq	#0,d0
;	movem.l	(sp)+,d0/a6
;	rts
	
InputHandler:
	move.l	a0,d0
	cmp.b	#1,4(a0)
	bne.s	.over

	move.l	a1,-(sp)
	lea	keyBuffer(pc),a1
	move.w	6(a0),d0
	cmp.w	#$80,d0
	bhs.s	.doqual
	
	move.b	d0,(a1)+
	cmp.w	#$45,d0
	beq.s	.esc

.doqual	move.w	8(a0),d0
	and.b	#$1f,d0
	beq.s	.noqual
	lsr.b	d0
	bcc.s	.nolsh
	move.b	#$60,(a1)+

.nolsh	lsr.b	d0
	bcc.s	.norsh
	move.b	#$61,(a1)+

.norsh	lsr.b	d0
	bcc.s	.nocaps
	move.b	#$62,(a1)+

.nocaps	lsr.b	d0
	bcc.s	.noctrl
	move.b	#$63,(a1)+

.noctrl	lsr.b	d0
	bcc.s	.noqual
	move.b	#$64,(a1)+
	
.noqual	move.b	#-1,(a1)+	; mark end of buffer
;	moveq	#0,d0
	move.l	(sp)+,a1
.over	move.l	a0,d0
	rts

.nokey	
	move.b	#-1,KeyBuffer	
	move.l	a0,d0
	rts

.esc
	move.l	(sp)+,a1
	move.b	#DOIRQ-start2-2,start2+1
	move.w	#-1,ISData
	move.l	a0,d0
	rts

openfile:
	move.l	#1005,d2
	move.l	dosbase,a6
	jsr	_LVOOpen(a6)
	move.l	d0,filehd
	rts

closefile:
	move.l	dosbase,a6
	move.l	filehd,d1
	jsr	_LVOClose(a6)
	rts

readdata:
	move.l	dosbase,a6
	move.l	filehd,d1
	jsr	_LVORead(a6)
	rts

pmsg:
	movem.l	d0-d7/a0-a6,-(sp)
	move.l	conhandle,d1
	move.l	dosbase,a6
	jsr	_LVOWrite(a6)		;write uses d1-file,d2-location,d3-len
	movem.l	(sp)+,d0-d7/a0-a6
	rts

hexin:
	tst.b	(a0)
	beq.s	hexinok
	cmp.b	#32,(a0)
	beq.s	hexinok
	moveq	#0,d0
	move.b	(a0)+,d0
	cmp.b	#$60,d0
	ble.s	upper
	sub.b	#$20,d0
upper:
	sub.b	#'A',d0
	bcc.s	ischar
	addq.b	#7,d0
ischar:
        add.b	#10,d0
	lsl.l	#4,d1
	or.b	d0,d1
	bra.s	hexin
hexinok:
	rts

loadROMs:
	move.w	#0,a5
	move.l	RTBase,a6
	move.l	freq,a1
	moveq	#0,d0
	sub.l	a0,a0
	jsr	_LVOrtAllocRequestA(a6)
	tst.l	d0
	beq	errorreq
	move.l	d0,freq
	move.l	d0,a1
	lea	myreqtag,a0
	jsr	_LVOrtChangeReqAttrA(a6)	;changes dir
	lea	buffer2(pc),a2		;Filename
	moveq	#0,d0
	lea	RTitle(pc),a3		;Title of requester
	move.l	freq,a1
	lea	freqtags,a0
	jsr	_LVOrtFileRequestA(a6)
 	tst.l	d0
	beq	cancel
	move.l	freq,a2
	move.l	16(a2),a2		;directory
	move.l	#buffer2,a0		;filename
	move.l	#inbuff,a1		;destination
	moveq	#0,d0
.loop
	move.b	(a2,d0),(a1,d0)
	addq.b	#1,d0
	cmp.b	#0,(a2,d0)
	beq.s	.done
	bra.s	.loop
.done
	cmp.b	#':',-1(a2,d0)
	beq.s	.over4
	move.b	#'/',(a1,d0)
	addq.b	#1,d0
.over4
	moveq	#0,d1
.loop3
	move.b	(a0,d1),(a1,d0)
	cmp.b	#0,(a1,d0)
	beq.s	readfile
	addq.b	#1,d1
	addq.b	#1,d0
	bra.s	.loop3

endreq:
	move.l	freq,a1
	move.l	RTbase,a6
	cmp.l	#0,a6
	beq.s	.end
	jsr	_LVOrtFreeRequest(a6)
	move.l	4.w,a6
	move.l	RTbase,a1
	jsr	_LVOCloseLibrary(a6)
.end
	rts

errorreq:
	rts

cancel:
	rts

readfile:
	move.l	dosbase,a6
	move.l	#inbuff,d1
	moveq	#-2,d2
	jsr	_LVOlock(a6)
	tst.l	d0
	beq.s	errorreq
	move.l	d0,locksav
	move.l	dosbase,a6
	move.l	locksav,d1
	move.l	#fileinfo,d2
	jsr	_LVOexamine(a6)
	move.l	locksav,d1
	jsr	_LVOunlock(a6)
	move.l	#fileinfo+124,a1
	move.l	(a1),filelen
	move.l	#fileinfo+144,a1
	move.l	#buffer,a0
	move.w	(a1),(a0)
	move.b	#0,2(a0)
	moveq	#0,d1
	bsr	hexin		;get A reg
	move.l	d1,areg
	move.w	3(a1),(a0)
	moveq	#0,d1
	bsr	hexin		;get X reg
	move.l	d1,xreg
	move.w	6(a1),(a0)
	moveq	#0,d1
	bsr	hexin		;get Y reg
	move.l	d1,yreg
	move.w	9(a1),(a0)
	moveq	#0,d1
	bsr	hexin		;get S reg
	move.l	d1,sreg
	move.l	12(a1),(a0)
	move.b	#0,4(a0)
	moveq	#0,d1
	bsr	hexin		;get SP
	move.l	d1,stackp
	move.l	17(a1),(a0)
	move.b	#0,4(a0)
	moveq	#0,d1
	bsr	hexin		;get PC
	move.l	d1,progc
	move.l	22(a1),(a0)
	move.b	#0,4(a0)
	moveq	#0,d1
	bsr	hexin		;get LA
	move.l	d1,loadaddr

	move.l	#kernel,d1
	bsr	openfile
	move.l	#$2000,d3
	move.l	address,d2
	add.l	#$e000,d2
	bsr	readdata
	bsr	closefile
	move.l	address,a1
	move.l	a1,a2		;copy roms
	add.l	#$12000,a2
	add.l	#$e000,a1
	moveq	#0,d0
.loop1	move.l	(a1,d0.l),(a2,d0.l)
	addq.l	#4,d0
	cmp.l	#$2000,d0
	bcs.s	.loop1

	move.l	#basic,d1
	bsr.w	openfile
	move.l	#$2000,d3
	move.l	address,d2
	add.l	#$a000,d2
	bsr	readdata
	bsr.w	closefile
	move.l	address,a1
	move.l	a1,a2		;copy roms
	add.l	#$10000,a2
	add.l	#$a000,a1
	moveq	#0,d0
.loop2	move.l	(a1,d0.l),(a2,d0.l)
	addq.l	#4,d0

	cmp.l	#$2000,d0
	bcs.s	.loop2

	move.l	#char,d1
	bsr.w	openfile
	move.l	#$1000,d3
	move.l	address,d2
	add.l	#$14000,d2
	move.l	d2,CROMAddy
	bsr.w	readdata
	bsr.w	closefile
	rts

codecopy:
	move.l	#inbuff,d1
	bsr	openfile
	move.l	address,d2
	add.l	loadaddr,d2
	move.l	filelen,d3
	bsr	readdata
	bsr	closefile
	rts

ISInterrupt:
	move.b	#doirq-start2-2,start2+1
	move.w	#1,ISData
	moveq	#0,d0
	rts

SetUpScreen:
	move.l	BPL1Address,a1
	move.l	#1999,d1
	moveq	#-1,d0
.loop
	move.l	d0,(a1)+
	dbra	d1,.loop

	rts

SetUpColourLookup:
	lea	ColLUT,a0
	moveq	#24,d0
	moveq	#18,d1
.loop
	moveq	#39,d2
.loop2
	move.w	d1,(a0)+
	addq.w	#4,d1
	dbra	d2,.loop2
	add.l	#20,d1
	dbra	d0,.loop
	rts

SetUpScreenLookup:
	lea	ScrLUT,a0
	move.l	#999,d2
	moveq	#0,d0
.lp
	move.l	d0,d6		; character offset from top left
	move.l	d6,d4
	divu	#40,d6
	and.l	#$ffff,d6
	mulu	#40,d6
	sub.l	d6,d4
	and.w	#$fffe,d4
	lsl.l	#5,d6
	add.l	d4,d6
	move.w	d6,(a0)+
	addq.l	#1,d0
	dbra	d2,.lp
	rts

; Mainloop register summary:
; Indented regs can be modified under controlled circumstances

;	a0 - MAR - Points to last 64 memory address used.
;	a1 - 	Write/Read base. Set at end of a 64 ins. Can fiddle with.
;	a2 - Write Base. Dont fiddle. Hands off! Capisce?
;	a3 - 64 Stack pointer. Leave top 16 bits ALONE!
;	a4 - 64 Program counter. Leave top 16 bits alone.
;	a5 - Pointer to address of last 020 routine of last c64 instruction.
;	a6 - Pointer to shadow RAM. Leave top 16 bits ALONE!
;	d0 - Accumulator. Top 24 bits must be zero.
;	d1 - X registor. Top 24 bits must be 0
;	d2 - Y register. Same as above.
;	d3 - C64 Status register.
;	d4 - 	Temp.		Read instructions must leave bits >15 = 0
;	d5 - 	Temp.
;	d6 - 	Temp.
;	d7 -	Temp.		Read instructions must leave bits 9-15 = 0

start:
	bsr.s	SetUpScreenLookup
	bsr.w	SetUpColourLookup
;	bsr.w	SetUpScreen
	bsr.w	loadROMs
	bsr.w	codecopy
	move.l	address,a6
	add.l	#$20000,a6
	bsr	InitSRAM
	move.l	screenhd,a0
	lea	44(a0),a0
	moveq	#40,d0
	lea	colour64(pc),a1
	move.l	gfxbase,a6
	jsr	_LVOLoadRGB4(a6)
	move.l	address,a4		;address of Alloc'ed mem
	move.l	a4,a6
	add.l	#$20000,a6		;a6 = ^ SRAM
	move.l	areg,d0			;d0=ac,d1=xr,d2=yr,d3=sr,a4=64pc
	move.l	xreg,d1
	move.l	yreg,d2
	move.l	sreg,d3
	move.l	#$10000,d3
	move.l	progc,d4
	move.l	stackp,a3
	add.l	a4,a3
	move.l	a4,d6
	move.l	a4,a0			;a3=64SP,a0=64MAR
	move.l	#$d018,d5
	move.b	#21,(a4,d5.l)
	lea	WriteBase,a2		; a2 is WriteBase
	add.l	d4,a4
	moveq	#0,d4
	move.l	a7,StackSave
	lea	table,a7
	moveq	#0,d7
	bra	start1

	cnop	0,4
				; reminder!!! d7 - Make sure all read ins
				; leave bits 8 to 15 = 0!!! NBNBNBNBNB

start2:
	bra.s	start1
RWcheck:
	move.w	a0,d4
	move.b	(a6,d4.l),d7
	beq.s	start2
	moveq	#1,d5
	jmp	([a1,d7.w*4])

start1:
	move.b	(a4)+,d7
	move.l	(a7,d7.w*4),a5
	jmp	(a5)

	cnop	0,4
				; reminder!!! D7 - Make sure all read ins
				; leave bits 8 to 15 = 0!!! NBNBNBNBNB
RWcheck2:
	move.w	a0,d4
	move.b	(a6,d4.l),d7
	beq.s	start2
	moveq	#2,d5
	jmp	([a1,d7.w*4])

PackA	Macro
	move.l	d3,d5
	move.l	d3,d7
	lsr.l	#8,d5
	lsr.l	#4,d5
	and.l	#$F0,d5
	and.l	#$0f,d7
	or.b	d5,d7
	ENDM
	
UnPackA Macro
	move.l	d3,d5
	and.l	#$f0,d5
	lsl.l	#8,d5
	lsl.l	#4,d5
	and.l	#$f,d3
	or.l	d5,d3
	ENDM

DOIRQ:
	cmp.w	#-1,ISData
	beq	qu
	move.w	#0,ISData
	btst	#16,d3
	bne.s	start1
	subq.w	#1,a3
	move.l	a4,d6
	ror.w	#8,d6
	move.w	d6,(a3)
	lea	ACTable,a1
	PackA
	move.b	(a1,d7),-(a3)
	bset	#16,d3
	subq.w	#1,a3
	move.w	#$fffe,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a4
	moveq	#0,d7
	move.b	#start1-start2-2,start2+1
	bra.s	start1

Freak:
	move.w	#$000,$dff180
	move.w	#$fff,$dff180
	btst.b	#6,$bfe001
	bne.s	Freak
	bra	qu

Done:
	btst	#6,$bfe001
	beq	qu
	bne.s	done

BeginRd Macro
	tst.l	RRepeat
	bne.s	.repover
	sub.w	d5,a4
	st	RRepeat
	ENDM

EndRd	Macro	
	jmp	(a5)
.repover
	clr	RRepeat
	jmp	Start2
	ENDM

	cnop	0,4

RasterR:
	BeginRd
	move.w	$dff006,d5	; OPTIMIZE **********************
	lsr.w	#8,d5
	move.b	d5,(a0)
	EndRd

	cnop	0,4

RasterW:
				; IMPLEMENT *********************
	bra.w	start2

; Shadow ram, contains routine identifiers showing what each byte of
; memory is attached to.
; Numbers are used to index into routine pointers stored in two tables
; One table for read, one for write
; a1 - read/write base base	a2 - write base
; Currently:
;	0 - no action
;	1 - KROMS - $e000-$ffff
;	2 - VIC Raster Control $d012
;	3 - BROMS - $a000-$bfff
;	4 - VIC screen
;	5 - MCR $d018
;	6 - Border colour $d020
;	7 - Screen colour $d021
;	8 - KeyWrite $dc00-write
;	9 - KeyRead $dc01-read

; PRE:	a6 MUST point to SRAM base
; POST:	Assume ALL registers except a6 trashed!

InitSRam:
	move.l	#8192-1,d0	; clear 8k of memory
	move.l	#$a000,d1
	move.l	#$e000,d2
.lp	move.b	#1,(a6,d2.l)
	move.b	#3,(a6,d1.l)
	addq.l	#1,d1
	addq.l	#1,d2
	dbra	d0,.lp
	move.l	#$d012,d7
	move.b	#2,(a6,d7.l)	; Raster Control
	move.l	#$d018,d7
	move.b	#55,(a6,d7.l)	; MCR
	move.l	#$d020,d7
	move.b	#6,(a6,d7.l)	; Border colour
	move.l	#$d021,d7
	move.b	#7,(a6,d7.l)	; Screen colour
	move.l	#$dc00,d7
	move.b	#8,(a6,d7.l)
	move.l	#$dc01,d7
	move.b	#9,(a6,d7.l)
	move.l	#2040,d7	;Sprite pointers
	move.b	#12,(a6,d7.l)
	move.l	#2041,d7
	move.b	#13,(a6,d7.l)
	move.l	#2042,d7
	move.b	#14,(a6,d7.l)
	move.l	#2043,d7
	move.b	#15,(a6,d7.l)
	move.l	#2044,d7
	move.b	#16,(a6,d7.l)
	move.l	#2045,d7
	move.b	#17,(a6,d7.l)
	move.l	#2046,d7
	move.b	#18,(a6,d7.l)
	move.l	#2047,d7
	move.b	#19,(a6,d7.l)
	move.l	#53269,d7	;Sprite Enable
	move.b	#20,(a6,d7.l)
	move.l	#53264,d7	;Sprite X MSB
	move.b	#21,(a6,d7.l)
	move.l	#53248,d7	;Sprite X
	move.b	#22,(a6,d7.l)
	move.l	#53249,d7	;Sprite Y
	move.b	#23,(a6,d7.l)
	move.l	#53250,d7
	move.b	#24,(a6,d7.l)
	move.l	#53251,d7
	move.b	#25,(a6,d7.l)
	move.l	#53252,d7
	move.b	#26,(a6,d7.l)
	move.l	#53253,d7
	move.b	#27,(a6,d7.l)
	move.l	#53254,d7
	move.b	#28,(a6,d7.l)
	move.l	#53255,d7
	move.b	#29,(a6,d7.l)
	move.l	#53256,d7
	move.b	#30,(a6,d7.l)
	move.l	#53257,d7
	move.b	#31,(a6,d7.l)
	move.l	#53258,d7
	move.b	#32,(a6,d7.l)
	move.l	#53259,d7
	move.b	#33,(a6,d7.l)
	move.l	#53260,d7
	move.b	#34,(a6,d7.l)
	move.l	#53261,d7
	move.b	#35,(a6,d7.l)
	move.l	#53262,d7
	move.b	#36,(a6,d7.l)
	move.l	#53263,d7
	move.b	#37,(a6,d7.l)
	move.l	#53287,d7
	move.b	#38,(a6,d7.l)
	move.l	#53288,d7
	move.b	#39,(a6,d7.l)
	move.l	#53289,d7
	move.b	#40,(a6,d7.l)
	move.l	#53290,d7
	move.b	#41,(a6,d7.l)
	move.l	#53291,d7
	move.b	#42,(a6,d7.l)
	move.l	#53292,d7
	move.b	#43,(a6,d7.l)
	move.l	#53293,d7
	move.b	#44,(a6,d7.l)
	move.l	#53294,d7
	move.b	#45,(a6,d7.l)
	move.l	#53276,d7		;Sprite MCM Enable
	move.b	#46,(a6,d7.l)
	move.l	#53285,d7		;Sprite Multi-Colour 0
	move.b	#47,(a6,d7.l)
	move.l	#53286,d7		;Sprite Multi-Colour 1
	move.b	#48,(a6,d7.l)
	move.l	#53277,d7		;Sprite Expand X
	move.b	#49,(a6,d7.l)
	move.l	#53271,d7		;Sprite Expand Y
	move.b	#50,(a6,d7.l)
	move.l	#53265,d7		;VIC Control Reg 1
	move.b	#51,(a6,d7.l)
	move.l	#53282,d7		;Background colour2
	move.b	#52,(a6,d7.l)
	move.l	#53283,d7		;Background colour3
	move.b	#53,(a6,d7.l)
	move.l	#53284,d7		;Background colour4
	move.b	#54,(a6,d7.l)
	move.l	#53270,d7		;VIC Control Reg 2
	move.b	#11,(a6,d7.l)

; Init VIC screen addr
	move.l	#1024,d7
	move.w	#249,d6
	move.l	#$04050405,a5
.lp2	move.l	a5,(a6,d7.l)
	addq.l	#4,d7
	dbra	d6,.lp2

; Init VIC Colour RAM
	move.l	#55296,d7
	move.w	#249,d6
	move.l	#$0a0a0a0a,a5
.lp3	move.l	a5,(a6,d7.l)
	addq.l	#4,d7
	dbra	d6,.lp3
	rts

	cnop	0,4

KROMs:
	move.l	a0,a1
	add.w	#$4000,a1
	move.b	(a1),(a0)	
	jmp	start2

	cnop	0,4

BROMs:
	move.l	a0,a1
	add.w	#$6000,a1
	move.b	(a1),(a0)
	jmp	start2

	cnop	0,4

MCR:
	move.b	(a0),d7
	and.l	#$E,d7
	move.l	d7,d5
	lsl.l	#8,d7
	lsl.l	#2,d7
	move.w	d7,d6
	move.l	d6,CROMAddy
	move.b	$ce8(a0),d7
	and.l	#3,d7
	eor.b	#$3,d7
	lsl.l	#8,d7
	lsl.l	#6,d7
	add.l	d7,CROMAddy
	tst.b	d7
	bne.s	.ov
	cmp.b	#4,d5
	beq.s	.upper
	cmp.b	#6,d5
	bne.s	.ov

.upper	add.l	#$13000,CROMAddy
		
.ov	move.b	(a0),d7
	and.l	#240,d7
	lsl.l	#6,d7
	move.w	MCRLast,d5
	move.w	d7,MCRLast
	move.w	#249,d6
	move.l	#$04050405,a1
.lp	move.l	#0,(a6,d5.w)
	move.l	a1,(a6,d7.w)
	addq.l	#4,d7
	addq.l	#4,d5
	dbra	d6,.lp
	tst.b	MCM
	beq.s	.over1
	bsr	RefreshMCM
	moveq	#0,d7
	jmp	start2
.over1
	tst.b	ECM
	beq.s	.over
	bsr	RefreshECM
	moveq	#0,d7
	jmp	start2
.over
	bsr	RefreshT
	moveq	#0,d7
	jmp	start2			; IMPLEMENT *****
MCRLast	dc.w	1024

	cnop	0,4

ColWrite:
	lea	Palette,a1
	lea	ColLUT,a5
	moveq	#0,d5
	move.w	a0,d5
	sub.w	#55296,d5
	move.w	(a5,d5.l*2),d5
	lea	Newcopper,a5
	move.b	(a0),d7
	tst.b	MCM
	beq.s	.over
	cmp.b	#8,d7
	blo.s	.mono
	and.w	#7,d7
	move.w	(a1,d7.l*2),(a5,d5)
	bra	MCMColWrite1
.mono
	and.w	#7,d7
	move.w	(a1,d7.l*2),(a5,d5)
	bra	MCMColWrite
.over
	and.w	#15,d7
	move.w	(a1,d7.l*2),(a5,d5)
	jmp	Start2

BorderCol:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),MyCopList+6
	jmp	start2

	cnop	0,4

ScreenCol:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),MyCopList+10
	jmp	start2

ScreenCol1:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	tst.b	MCM
	beq.s	.over
	move.w	(a1,d7.l*2),MultiC+6
	jmp	start2
.over
	move.w	(a1,d7.l*2),MultiC+2
	jmp	start2

ScreenCol2:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	tst.b	MCM
	beq.s	.over
	move.w	(a1,d7.l*2),MultiC+2
	jmp	start2
.over
	move.w	(a1,d7.l*2),MultiC+10
	jmp	start2

ScreenCol3:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),MultiC+14
	jmp	start2

	cnop	0,4

VCRW1:
	move.b	(a0),d7
	btst	#6,d7
	bne.s	.SetECM
	move.l	#DoScreen0,Writebase+16
	tst.b	ECM
	beq.s	.over
	addq.w	#7,a0
	bsr	RefreshSCM
	sf.b	ECM
.over
	jmp	start2
.SetECM
	move.l	#DoECM,Writebase+16
	st.b	ECM
	addq.w	#7,a0
	bsr	RefreshECM
	jmp	start2

VCRW2:
	move.b	(a0),d7
	btst	#4,d7
	bne.s	.SetMCM
	move.l	#DoScreen0,Writebase+16
	tst.b	MCM
	beq.s	.over
	addq.w	#2,a0
	bsr	RefreshSCM
	sf.b	MCM
.over
	jmp	start2
.SetMCM
	move.l	#MCMWrite,Writebase+16
	st.b	MCM
	addq.w	#2,a0
	bsr	RefreshMCM
	jmp	start2

RefreshT:
	movem.l	a0-a2,-(sp)
	move.b	(a0),d7
	and.l	#240,d7
	lsl.l	#6,d7		;gets pointer to screen in 53272
	move.w	d7,d6
	move.l	d6,a0
	move.l	CROMAddy,a2
	move.l	BM1Addy,a5
	moveq	#0,d5
	move.w	ScrLUT,d5
	add.l	d5,a5
	move.w	#24,d4
.lp3
	move.w	#39,d6
.lp2	
	moveq	#0,d5
	move.b	(a0)+,d5
	lsl.l	#3,d5
	lea	(a2,d5.l),a1
	
	moveq	#3,d7
.loop
	move.b	(a1)+,(a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a2
	rts

RefreshSCM:
	movem.l	a0-a2,-(sp)
	move.b	(a0),d7
	and.l	#240,d7
	lsl.l	#6,d7		;gets pointer to screen in 53272
	move.w	d7,d6
	move.l	d6,a0
	move.l	CROMAddy,a2
	move.l	BM1Addy,a5
	moveq	#0,d5
	move.w	ScrLUT,d5
	add.l	d5,a5
	move.w	#24,d4
.lp3
	move.w	#39,d6
.lp2
	moveq	#0,d5
	move.b	(a0)+,d5
	lsl.l	#3,d5
	lea	(a2,d5.l),a1

	moveq	#3,d7
.loop
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a2
	rts

RefreshECM:
	movem.l	a0-a2,-(sp)
	move.b	(a0),d7
	and.l	#240,d7
	lsl.l	#6,d7		;gets pointer to screen in 53272
	move.w	d7,d6
	move.l	d6,a0
	move.l	CROMAddy,a2
	move.l	BM1Addy,a5
	moveq	#0,d5
	move.w	ScrLUT,d5
	add.l	d5,a5
	move.w	#24,d4
.lp3
	move.w	#39,d6
.lp2	
	moveq	#0,d5
	move.b	(a0)+,d5
	and.b	#63,d5
	lsl.l	#3,d5
	lea	(a2,d5.l),a1
	
	moveq	#3,d7
	btst	#7,-1(a0)
	bne	.bit7
	btst	#6,-1(a0)
	bne	.bit6
.loop
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a2
	rts

.bit7
	btst	#6,-1(a0)
	bne	.bit76
.loop1
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop1
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a2
	rts

.bit6
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.bit6
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a2
	rts

.bit76
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	d5,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	d5,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.bit76
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a2
	rts

RefreshMCM:
	movem.l	a0-a4,-(sp)
	move.b	(a0),d7
	and.l	#240,d7
	lsl.l	#6,d7		;gets pointer to screen in 53272
	move.w	d7,d6
	move.l	d6,a0
	move.w	#$d800,d6
	move.l	d6,a4		;colour memory
	move.l	CROMAddy,a2
	move.l	BM1Addy,a5
	moveq	#0,d5
	move.w	ScrLUT,d5
	add.l	d5,a5
	move.w	#24,d4
	lea	multi,a3
	moveq	#0,d5
.lp3
	move.w	#39,d6
.lp2	
	move.b	(a0)+,d5
	lsl.l	#3,d5
	lea	(a2,d5.l),a1
	
	moveq	#3,d7
	moveq	#0,d5
	cmp.b	#8,(a4)+
	blo.s	.mono
.loop
	move.b	(a1)+,d5
	move.b	(a3,d5*2),(a5)
	move.b	1(a3,d5*2),(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	(a3,d5*2),(a5)
	move.b	1(a3,d5*2),(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a4
	rts
.mono
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.mono
	sub.l	#319,a5
	dbra	d6,.lp2
	add.l	#280,a5
	dbra	d4,.lp3
	movem.l	(sp)+,a0-a4
	rts

ReadJOY2:
	move.w	$dff00c,d5
	move.w	d5,d7
	and.w	#$300,d5
	and.w	#$3,d7
	lsr.w	#6,d5
	or.w	d7,d5
	lea	JoyTable,a5
	move.b	(a5,d5.w),d5
	move.b	(a0),d7
	and.w	#$e0,d7
	or.b	d5,d7
	move.b	$bfe001,d5
	and.b	#128,d5
	lsr.b	#3,d5
	or.b	d5,d7
	or.b	#$60,d7
	move.b	d7,(a0)
	move.b	d7,KeyWSt
	jmp	start2

KeyWrite:
	moveq	#0,d7
	move.b	(a0),d7
	move.w	d7,keybank
	move.b	KeyWSt,(a0)
	jmp	start2

DoubleY	macro
	tst.b	Sprite\2YY
	beq.s	.fin\1
	lea	Sprite\2+336,a1
	lea	Sprite\2+672,a5
	moveq	#20,d4
.loop\1
	move.l	(a1),(a5)
	move.l	(a1),-16(a5)
	move.l	4(a1),4(a5)
	move.l	4(a1),-12(a5)
	move.l	8(a1),8(a5)
	move.l	8(a1),-8(a5)
	move.l	12(a1),12(a5)
	move.l	12(a1),-4(a5)
	sub.l	#16,a1
	sub.l	#32,a5
	dbra	d4,.loop\1
.fin\1
	ENDM

MultiC	Macro
	move.l	a2,-(sp)
	lea	data,a2
	sub.w	d6,d6
.multi
	move.b	(a1)+,d6
	move.b	(a2,d6*2),(a5)+
	move.b	1(a2,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),(a5)+
	move.b	1(a2,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),(a5)+
	move.b	1(a2,d6*2),7(a5)
	add.l	#13,a5
	dbra	d5,.multi
	move.l	(sp)+,a2
	ENDM

MonoEX	Macro
	moveq	#0,d4
	move.l	a2,-(sp)
	lea	Expand,a2
.loop4
	move.b	(a1)+,d4
	move.w	(a2,d4*2),(a5)+
	move.b	(a1)+,d4
	move.w	(a2,d4*2),(a5)+
	move.b	(a1)+,d4
	move.w	(a2,d4*2),(a5)+
	add.l	#10,a5
	dbra	d5,.loop4
	move.l	(sp)+,a2
	ENDM

MultiEX	Macro
	moveq	#0,d4
	movem.l	a2/a3,-(sp)
	lea	data,a2
	lea	expand,a3
	sub.w	d6,d6
.loop5
	move.b	(a1)+,d6
	move.b	(a2,d6*2),d4
	move.w	(a3,d4*2),(a5)+
	move.b	1(a2,d6*2),d4
	move.w	(a3,d4*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),d4
	move.w	(a3,d4*2),(a5)+
	move.b	1(a2,d6*2),d4
	move.w	(a3,d4*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a2,d6*2),d4
	move.w	(a3,d4*2),(a5)+
	move.b	1(a2,d6*2),d4
	move.w	(a3,d4*2),6(a5)
	add.l	#10,a5
	dbra	d5,.loop5
	movem.l	(sp)+,a2/a3
	ENDM

Mono	Macro
.monolp
	move.w	(a1)+,(a5)+
	move.b	(a1)+,(a5)+
	clr.l	5(a5)
	add.l	#13,a5
	dbra	d5,.monolp
	ENDM

SpriteEN:
	move.b	(a0),d6
	move.l	#Sprite0,d7
	move.l	#NullSprite,d4
	lea	CSprite,a1
	lea	Sprite0A,a5
	moveq	#7,d5
.loop
	lsr.b	#1,d6
	bcc.s	.over
	move.w	d7,6(a1)
	swap	d7
	move.w	d7,2(a1)
	swap	d7
	add.l	#736,d7
	addq.l	#8,a1
	st.b	(a5)+
	dbra	d5,.loop
	moveq	#0,d7
	moveq	#0,d4
	jmp	start2
.over
	move.w	d4,6(a1)
	swap	d4
	move.w	d4,2(a1)
	swap	d4
	add.l	#736,d7
	addq.l	#8,a1
	sf.b	(a5)+
	dbra	d5,.loop
	moveq	#0,d7
	moveq	#0,d4
	jmp	start2

Sprite0X:
	bclr	#0,sprite0+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite0MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite0+9
.over1
	move.b	d5,sprite0+1
	jmp	start2

Sprite0Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite0
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite0+8
	jmp	start2

Sprite0P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite0PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite0+16,a5
	moveq	#20,d5
	tst.b	Sprite0MC
	beq	.mono
	tst.b	Sprite0XX
	bne	.multix
	MultiC
	DoubleY	0,0
	jmp	start2
.mono
	tst.b	Sprite0XX
	bne.s	.monox
	Mono
	DoubleY	1,0
	jmp	start2

.monox
	MonoEX
	DoubleY	2,0
	jmp	start2

.multix
	MultiEX
	DoubleY	3,0
	jmp	start2

Sprite1X:
	bclr	#0,sprite1+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite1MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite1+9
.over1
	move.b	d5,sprite1+1
	jmp	start2

Sprite1Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite1
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite1+8
	jmp	start2

Sprite1P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite1PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite1+16,a5
	moveq	#20,d5
	tst.b	Sprite1MC
	beq	.mono
	tst.b	Sprite1XX
	bne	.multix
	MultiC
	DoubleY	0,1
	jmp	start2
.mono
	tst.b	Sprite1XX
	bne.s	.monox
	Mono
	DoubleY	1,1
	jmp	start2

.monox
	MonoEX
	DoubleY	2,1
	jmp	start2

.multix
	MultiEX
	DoubleY	3,1
	jmp	start2

Sprite2X:
	bclr	#0,sprite2+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite2MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite2+9
.over1
	move.b	d5,sprite2+1
	jmp	start2

Sprite2Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite2
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite2+8
	jmp	start2

Sprite2P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite2PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite2+16,a5
	moveq	#20,d5
	tst.b	Sprite2MC
	beq	.mono
	tst.b	Sprite2XX
	bne	.multix
	MultiC
	DoubleY	0,2
	jmp	start2
.mono
	tst.b	Sprite2XX
	bne.s	.monox
	Mono
	DoubleY	1,2
	jmp	start2

.monox
	MonoEX
	DoubleY	2,2
	jmp	start2

.multix
	MultiEX
	DoubleY	3,2
	jmp	start2

Sprite3X:
	bclr	#0,sprite3+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite3MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite3+9
.over1
	move.b	d5,Sprite3+1
	jmp	start2

Sprite3Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite3
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite3+8
	jmp	start2

Sprite3P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite3PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite3+16,a5
	moveq	#20,d5
	tst.b	Sprite3MC
	beq	.mono
	tst.b	Sprite3XX
	bne	.multix
	MultiC
	DoubleY	0,3
	jmp	start2
.mono
	tst.b	Sprite3XX
	bne.s	.monox
	Mono
	DoubleY	1,3
	jmp	start2

.monox
	MonoEX
	DoubleY	2,3
	jmp	start2

.multix
	MultiEX
	DoubleY	3,3
	jmp	start2

Sprite4X:
	bclr	#0,sprite4+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite4MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite4+9
.over1
	move.b	d5,sprite4+1
	jmp	start2

Sprite4Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite4
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite4+8
	jmp	start2

Sprite4P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite4PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite4+16,a5
	moveq	#20,d5
	tst.b	Sprite4MC
	beq	.mono
	tst.b	Sprite4XX
	bne	.multix
	MultiC
	DoubleY	0,4
	jmp	start2
.mono
	tst.b	Sprite4XX
	bne.s	.monox
	Mono
	DoubleY	1,4
	jmp	start2

.monox
	MonoEX
	DoubleY	2,4
	jmp	start2

.multix
	MultiEX
	DoubleY	3,4
	jmp	start2

Sprite5X:
	bclr	#0,sprite5+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite5MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite5+9
.over1
	move.b	d5,sprite5+1
	jmp	start2

Sprite5Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite5
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite5+8
	jmp	start2

Sprite5P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite5PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite5+16,a5
	moveq	#20,d5
	tst.b	Sprite5MC
	beq	.mono
	tst.b	Sprite5XX
	bne	.multix
	MultiC
	DoubleY	0,5
	jmp	start2
.mono
	tst.b	Sprite5XX
	bne.s	.monox
	Mono
	DoubleY	1,5
	jmp	start2

.monox
	MonoEX
	DoubleY	2,5
	jmp	start2

.multix
	MultiEX
	DoubleY	3,5
	jmp	start2

Sprite6X:
	bclr	#0,sprite6+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite6MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite6+9
.over1
	move.b	d5,sprite6+1
	jmp	start2

Sprite6Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite6
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite6+8
	jmp	start2

Sprite6P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite6PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite6+16,a5
	moveq	#20,d5
	tst.b	Sprite6MC
	beq	.mono
	tst.b	Sprite6XX
	bne	.multix
	MultiC
	DoubleY	0,6
	jmp	start2
.mono
	tst.b	Sprite6XX
	bne.s	.monox
	Mono
	DoubleY	1,6
	jmp	start2

.monox
	MonoEX
	DoubleY	2,6
	jmp	start2

.multix
	MultiEX
	DoubleY	3,6
	jmp	start2

Sprite7X:
	bclr	#0,sprite7+9
	moveq	#0,d5
	move.b	(a0),d5
	add.w	#64+40,d5
	add.w	Sprite7MSB,d5
	lsr.w	#1,d5
	bcc.s	.over1
	bset	#0,sprite7+9
.over1
	move.b	d5,sprite7+1
	jmp	start2

Sprite7Y:
	moveq	#0,d5
	move.b	(a0),d5
	subq.b	#2,d5
	move.b	d5,sprite7
	add.b	#44,d5
	lsl.w	#8,d5
	move.w	d5,sprite7+8
	jmp	start2

Sprite7P:
	sub.w	d6,d6
	move.b	(a0),d6
	move.b	d6,Sprite7PT
	lsl.w	#6,d6
	move.l	d6,a1
	lea	Sprite7+16,a5
	moveq	#20,d5
	tst.b	Sprite7MC
	beq	.mono
	tst.b	Sprite7XX
	bne	.multix
	MultiC
	DoubleY	0,7
	jmp	start2
.mono
	tst.b	Sprite7XX
	bne.s	.monox
	Mono
	DoubleY	1,7
	jmp	start2

.monox
	MonoEX
	DoubleY	2,7
	jmp	start2

.multix
	MultiEX
	DoubleY	3,7
	jmp	start2

Sprite0C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
;	move.w	(a1,d7.l*2),SColour0+2
	jmp	start2

Sprite1C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),SColour1+2
	jmp	start2

Sprite2C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
;	move.w	(a1,d7.l*2),SColour0+6
	jmp	start2

Sprite3C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),SColour1+6
	jmp	start2

Sprite4C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
;	move.w	(a1,d7.l*2),SColour0+10
	jmp	start2

Sprite5C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),SColour1+10
	jmp	start2

Sprite6C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
;	move.w	(a1,d7.l*2),SColour0+14
	jmp	start2

Sprite7C:
	move.b	(a0),d7
	and.w	#$f,d7
	lea	Palette,a1
	move.w	(a1,d7.l*2),SColour1+14
	jmp	start2

SpriteMSBX:
	move.b	(a0),d7
	moveq	#7,d5
	lea	Sprite0+1,a1
	lea	Sprite0MSB,a5
.loop
	lsr.b	#1,d7
	bcc.s	.over
	move.w	#256,(a5)+
	or.b	#128,(a1)
	add.l	#736,a1
	dbra	d5,.loop
	jmp	start2
.over
	move.w	#0,(a5)+
	and.b	#127,(a1)
	add.l	#736,a1
	dbra	d5,.loop
	jmp	start2

SpriteMCM:
	sub.w	d6,d6
	movem.l	a2-a4,-(sp)
	lea	Sprite0PT,a2
	lea	Sprite0+16,a5
	lea	Data,a3
	lea	Expand,a4
	move.b	(a0),d7
	moveq	#7,d5
.main	
	move.b	(a2)+,d6
	lsl.w	#6,d6
	move.l	d6,a1
	moveq	#20,d4
	lsr.b	#1,d7
	bcc	.mono
	st.b	-17(a2)
	tst.b	7(a2)			;SpritexXX
	bne.s	.multix
	tst.b	15(a2)
	bne	.multiy
	sub.w	d6,d6
.loop
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	1(a3,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	1(a3,d6*2),7(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	1(a3,d6*2),7(a5)
	add.l	#13,a5
	dbra	d4,.loop
	add.l	#400,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.multix
	move.l	d0,-(sp)
	sub.w	d6,d6
	tst.b	15(a2)
	bne	.multixy
.loop1
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	add.l	#10,a5
	dbra	d4,.loop1
	move.l	(sp)+,d0
	add.l	#400,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.mono
	sf.b	-17(a2)
	tst.b	7(a2)
	bne.s	.monox
	tst.b	15(a2)
	bne	.monoy
.loop2
	move.w	(a1)+,(a5)+
	move.b	(a1)+,(a5)+
	clr.l	5(a5)
	add.l	#13,a5
	dbra	d4,.loop2
	add.l	#400,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.monox
	sub.w	d6,d6
	tst.b	15(a2)
	bne.s	.monoxy
.loop4
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	clr.l	2(a5)
	clr.l	6(a5)
	add.l	#10,a5
	dbra	d4,.loop4
	add.l	#400,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.monoxy
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.w	(a4,d6*2),14(a5)
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.w	(a4,d6*2),14(a5)
	move.b	(a1)+,d6
	move.w	(a4,d6*2),(a5)+
	move.w	(a4,d6*2),14(a5)
	clr.l	2(a5)
	clr.l	6(a5)
	clr.l	18(a5)
	clr.l	22(a5)
	add.l	#26,a5
	dbra	d4,.monoxy
	add.l	#64,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.monoy
	move.w	(a1),(a5)+
	move.w	(a1)+,14(a5)
	move.b	(a1),(a5)+
	move.b	(a1)+,15(a5)
	clr.l	5(a5)
	clr.l	21(a5)
	add.l	#29,a5
	dbra	d4,.monoy
	add.l	#64,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.multixy
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.w	(a4,d0*2),14(a5)
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.w	(a4,d0*2),22(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.w	(a4,d0*2),14(a5)
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.w	(a4,d0*2),22(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),d0
	move.w	(a4,d0*2),(a5)+
	move.w	(a4,d0*2),14(a5)
	move.b	1(a3,d6*2),d0
	move.w	(a4,d0*2),6(a5)
	move.w	(a4,d0*2),22(a5)
	add.l	#26,a5
	dbra	d4,.multixy
	move.l	(sp)+,d0
	add.l	#64,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

.multiy
	sub.w	d6,d6
.loop3
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	(a3,d6*2),15(a5)
	move.b	1(a3,d6*2),7(a5)
	move.b	1(a3,d6*2),23(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	(a3,d6*2),15(a5)
	move.b	1(a3,d6*2),7(a5)
	move.b	1(a3,d6*2),23(a5)
	move.b	(a1)+,d6
	move.b	(a3,d6*2),(a5)+
	move.b	(a3,d6*2),15(a5)
	move.b	1(a3,d6*2),7(a5)
	move.b	1(a3,d6*2),23(a5)
	add.l	#29,a5
	dbra	d4,.loop3
	add.l	#64,a5
	dbra	d5,.main
	movem.l	(sp)+,a2-a4
	jmp	start2

SpriteMC0:
	move.b	(a0),d5
	and.w	#$f,d5
	lea	Palette,a1
	move.w	(a1,d5.l*2),d5
;	lea	MColour0,a1
	lea	MColour1,a5
;	move.w	d5,2(a1)
;	move.w	d5,10(a1)
;	move.w	d5,18(a1)
;	move.w	d5,26(a1)
	move.w	d5,2(a5)
	move.w	d5,10(a5)
	move.w	d5,18(a5)
	move.w	d5,26(a5)
	jmp	start2

SpriteMC1:
	move.b	(a0),d5
	and.w	#$f,d5
	lea	Palette,a1
	move.w	(a1,d5.l*2),d5
;	lea	MColour0,a1
	lea	MColour1,a5
;	move.w	d5,6(a1)
;	move.w	d5,14(a1)
;	move.w	d5,22(a1)
;	move.w	d5,30(a1)
	move.w	d5,6(a5)
	move.w	d5,14(a5)
	move.w	d5,22(a5)
	move.w	d5,30(a5)
	jmp	start2

SpriteXX:
	move.b	(a0),d7
	movem.l	d0/a2,-(sp)
	lea	Sprite0XX,a2
	lea	Sprite0+16,a1
	moveq	#7,d5
.main
	lsr.b	#1,d7
	bcc.s	.shrink
	tst.b	(a2)+
	bne.s	.leave
	st.b	-1(a2)
	lea	Expand,a5
	moveq	#41,d4
	sub.w	d6,d6
.loop
	move.l	(a1),d0			;data
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	addq.l	#2,a1
	move.l	(a1),d0			;colour
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	rol.l	#8,d0
	move.b	d0,d6
	move.w	(a5,d6*2),(a1)+
	addq.l	#2,a1
	dbra	d4,.loop
	add.l	#64,a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	jmp	start2
.leave
	add.l	#736,a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	jmp	start2

.shrink
	tst.b	(a2)+
	beq.s	.leave
	sf.b	-1(a2)
	sub.w	d6,d6
	move.b	-9(a2),d6		;SpritexPT
	lsl.w	#6,d6
	move.l	d6,a5
	moveq	#20,d4
	tst.b	-25(a2)			;SpritexMC
	bne.s	.multi
	tst.b	7(a2)
	bne.s	.vert
.loop2	
	move.w	(a5)+,(a1)+
	move.b	(a5)+,(a1)+
	clr.b	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d4,.loop2
	add.l	#400,a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	jmp	start2
.vert
	move.w	(a5),(a1)+
	move.b	2(a5),(a1)+
	clr.b	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	move.w	(a5)+,(a1)+
	move.b	(a5)+,(a1)+
	clr.b	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d4,.vert
	add.l	#64,a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	jmp	start2
.multi
	move.l	a3,-(sp)
	lea	data,a3
	sub.w	d6,d6
	tst.b	7(a2)
	bne.s	.multiv
.loop3
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	(a3,d6*2),7(a1)
	clr.b	(a1)+
	clr.l	(a1)+
	clr.b	3(a1)
	clr.l	4(a1)
	addq.l	#8,a1
	dbra	d4,.loop3
	move.l	(sp)+,a3
	add.l	#400,a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	jmp	start2

.multiv
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a3,d6*2),15(a1)
	move.b	1(a3,d6*2),23(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a3,d6*2),15(a1)
	move.b	1(a3,d6*2),23(a1)
	move.b	(a5)+,d6
	move.b	(a3,d6*2),(a1)+
	move.b	1(a3,d6*2),7(a1)
	move.b	(a3,d6*2),15(a1)
	move.b	1(a3,d6*2),23(a1)
	clr.b	(a1)+
	clr.b	15(a1)
	clr.l	(a1)+
	clr.l	12(a1)
	clr.b	3(a1)
	clr.l	4(a1)
	clr.b	19(a1)
	clr.l	20(a1)
	add.l	#24,a1
	dbra	d4,.multiv
	move.l	(sp)+,a3
	add.l	#64,a1
	dbra	d5,.main
	movem.l	(sp)+,d0/a2
	jmp	start2

SpriteYY:
	move.b	(a0),d7
	move.l	a2,-(sp)
	lea	Sprite0+336,a1		;Halfway down the sprite?
	lea	Sprite0+672,a5		;Last Row of Sprite data?
	lea	Sprite0YY,a2
	moveq	#7,d5
.main
	lsr.b	#1,d7
	bcc.s	.shrink
	tst.b	(a2)+
	bne	.leave
	st.b	-1(a2)
	moveq	#20,d4
.expand
	move.l	(a1),(a5)
	move.l	(a1),-16(a5)
	move.l	4(a1),4(a5)
	move.l	4(a1),-12(a5)
	move.l	8(a1),8(a5)
	move.l	8(a1),-8(a5)
	move.l	12(a1),12(a5)
	move.l	12(a1),-4(a5)
	sub.l	#16,a1
	sub.l	#32,a5
	dbra	d4,.expand
	add.l	#1072,a1
	add.l	#1408,a5
	dbra	d5,.main
	move.l	(sp)+,a2
	jmp	start2
.shrink
	tst.b	(a2)+
	beq.s	.leave
	sf.b	-1(a2)
	moveq	#21,d4
.loop
	move.l	-624(a5),-304(a1)
	move.l	-620(a5),-300(a1)
	move.l	-616(a5),-296(a1)
	move.l	-612(a5),-292(a1)
	add.l	#16,a1
	add.l	#32,a5
	dbra	d4,.loop
	sub.l	#336,a1
	moveq	#20,d4
.loop1
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	clr.l	(a1)+
	dbra	d4,.loop1
	add.l	#384,a1
	add.l	#32,a5
	dbra	d5,.main
	move.l	(sp)+,a2
	jmp	start2
.leave
	add.l	#736,a1
	add.l	#736,a5
	dbra	d5,.main
	move.l	(sp)+,a2
	jmp	start2
KeyRead:
;keyqual	lshift  	- bit 0 set
;		rshift 		- bit 1 set
;		caps lock 	- bit 2 set
;		ctrl 		- bit 3 set
;		lalt = CBM	- bit 4 set

	BeginRd
	cmp.b	#-1,KeyBuffer
	beq.s	Nokey
;	cmp.b	#$61,Keybuffer
;	bne.s	.ov1
;	nop
;.ov1
	move.l	a2,-(sp)
	lea	KeyBuffer,a2
	lea	KeyMapTable,a1
	move.b	#-1,(a0)
	moveq	#0,d7
.lp	move.b	(a2)+,d7
	cmp.b	#-1,d7
	beq.s	.fin

	move.w	(a1,d7.w*2),d6
	move.w	KeyBank,d7
	eor.b	#-1,d7
	and.b	d6,d7
	beq.s	.lp

	ror.w	#8,d6
	and.b	d6,(a0)

	bra.s	.lp
.fin	move.l	(sp)+,a2
	EndRd
Nokey:
	move.b	#-1,(a0)
	EndRd

DoScreen0:
	move.l	a6,-(sp)
	moveq	#0,d5
	move.l	d6,d4
	and.l	#1023,d4
	move.b	(a0),d7
	move.w	(ScrLut,d4.l*2),d5
	lsl.l	#6,d7
	add.l	BPL1Address,d5
	lea	(BlitCharSet,d7.l),a5

	move.l	gfxbase,a6
	jsr	_LVOOwnBlitter(a6)
	jsr	_LVOWaitBlit(a6)
	move.l	#$dff000,a1

	move.w	#$07ca,bltcon0(a1)
	move.w	#0,bltcon1(a1)
	move.w	#$ff00,bltafwm(a1)
	move.w	#$ff00,bltalwm(a1)
	move.w	#0,bltamod(a1)
	move.w	#0,bltbmod(a1)
	move.w	#$0026,bltcmod(a1)
	move.w	#$0026,bltdmod(a1)
	move.w	#$ffff,bltadat(a1)
	move.l	a5,bltbpth(a1)
	move.l	d5,bltcpth(a1)
	move.l	d5,bltdpth(a1)
	move.w	#$0801,bltsize(a1)

	jsr	_LVODisownBlitter(a6)

	move.l	(sp)+,a6
	moveq	#0,d7
	jmp	start2

DoScreen1:
	move.l	a6,-(sp)
	moveq	#0,d5
	move.l	d6,d4
	and.l	#1023,d4
	move.b	(a0),d7
	move.w	(ScrLut,d4.l*2),d5
	lsl.l	#6,d7
	add.l	BPL1Address,d5
	lea	(BlitCharSet,d7.l),a5

	move.l	gfxbase,a6
	jsr	_LVOOwnBlitter(a6)
	jsr	_LVOWaitBlit(a6)
	move.l	#$dff000,a1

	move.w	#$07ca,bltcon0(a1)
	move.w	#0,bltcon1(a1)
	move.w	#$00ff,bltafwm(a1)
	move.w	#$00ff,bltalwm(a1)
	move.w	#0,bltamod(a1)
	move.w	#0,bltbmod(a1)
	move.w	#$0026,bltcmod(a1)
	move.w	#$0026,bltdmod(a1)
	move.w	#$ffff,bltadat(a1)
	move.l	a5,bltbpth(a1)
	move.l	d5,bltcpth(a1)
	move.l	d5,bltdpth(a1)
	move.w	#$0801,bltsize(a1)

	jsr	_LVODisownBlitter(a6)

	move.l	(sp)+,a6
	moveq	#0,d7
	jmp	start2

DoECM:
	moveq	#0,d5
	move.l	d6,d4
	and.l	#1023,d4
	move.b	(a0),d5
	and.b	#63,d5
	move.w	(ScrLut,d4.l*2),a5
	add.l	BM1Addy,a5
	lea	([CROMAddy],d5.l*8),a1
	moveq	#3,d7

	btst	#7,(a0)
	bne.s	.bit7
	btst	#6,(a0)
	bne.s	.bit6
.loop	
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	moveq	#0,d7
	jmp	start2

.bit7
	btst	#6,(a0)
	bne.s	.bit76
.loop1
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop1
	moveq	#0,d7
	jmp	start2

.bit6
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(8000.w,a5)
	move.b	#0,(16000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.bit6
	moveq	#0,d7
	jmp	start2

.bit76
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	d5,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	d5,(a5)
	eor.b	#255,d5
	move.b	d5,(16000.w,a5)
	move.b	d5,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.bit76
	moveq	#0,d7
	jmp	start2

MCMWrite:
	move.l	a2,-(sp)
	moveq	#0,d5
	move.l	d6,d4
	and.l	#1023,d4
	move.b	(a0),d5
	move.w	(ScrLut,d4.l*2),a5
	add.l	BM1Addy,a5
	lea	([CROMAddy],d5.l*8),a1
	moveq	#3,d7
	lea	multi,a2
	add.l	#$d400,a0
	cmp.b	#8,(a0)
	blo.s	.mono
.loop
	move.b	(a1)+,d5
	move.b	(a2,d5*2),(a5)
	move.b	1(a2,d5*2),(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	(a2,d5*2),(a5)
	move.b	1(a2,d5*2),(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	moveq	#0,d7
	move.l	(sp)+,a2
	jmp	start2
.mono
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.mono
	moveq	#0,d7
	move.l	(sp)+,a2
	jmp	start2

MCMColWrite:
	moveq	#0,d5
	move.l	d6,d4
	sub.l	#$d400,a0
	and.l	#1023,d4
	move.b	(a0),d5
	move.w	(ScrLut,d4.l*2),a5
	add.l	BM1Addy,a5
	lea	([CROMAddy],d5.l*8),a1
	moveq	#3,d7
.loop
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,(a5)
	move.b	#0,(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	moveq	#0,d7
	jmp	start2

MCMColWrite1:
	move.l	a2,-(sp)
	moveq	#0,d5
	move.l	d6,d4
	sub.l	#$d400,a0
	and.l	#1023,d4
	move.b	(a0),d5
	move.w	(ScrLut,d4.l*2),a5
	add.l	BM1Addy,a5
	lea	([CROMAddy],d5.l*8),a1
	moveq	#3,d7
	lea	multi,a2
.loop
	move.b	(a1)+,d5
	move.b	(a2,d5*2),(a5)
	move.b	1(a2,d5*2),(8000.w,a5)
	lea	(40.w,a5),a5
	move.b	(a1)+,d5
	move.b	(a2,d5*2),(a5)
	move.b	1(a2,d5*2),(8000.w,a5)
	lea	(40.w,a5),a5
	dbra	d7,.loop
	moveq	#0,d7
	move.l	(sp)+,a2
	jmp	start2

	cnop	0,4

InitSID:
	rts		
SIDInt:
	movem.l	d0-a6,-(sp)
	move.l	address,a0	; get pointer to C64 memory
	add.l	#54272,a0	; point to beginning of SID area
	moveq	#0,d0
	move.b	1(a0),d0
	lsl.l	#8,d0
	move.b	(a0),d0		; get voice 1 freq. Put into D0
	addq.l	#2,a0
	moveq	#0,d1
	move.b	1(a0),d1
	lsl.l	#8,d1
	move.b	(a0),d1		; get voice 1 pulse width. Put into D1
	addq.l	#2,a0
	move.l	(a0),d2		; d2 is control + A/D + S/R MSB-LSB (I think ;)
	btst	#28,d2
	movem.l	(sp)+,d0-a6
	rts			; CHANGE to RTE later maybe - depends on what
				; calls it

FlagNZ	Macro
	move	ccr,d5
	and.w	#3,d3
	and.w	#12,d5
	or.b	d5,d3
	ENDM

FlagCNZ	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#13,d5
	or.b	d5,d3
	ENDM

FlagCMP	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#13,d5
	eor.b	#1,d5
	or.b	d5,d3
	ENDM

FlagSUB	Macro
	bchg	#0,d3
	lsr.b	d3
	moveq	#0,d5
	subx.b	d6,d0
	move	ccr,d3
	bchg	#0,d3
	ENDM

FlagADD Macro
	lsr.b	d3
	moveq	#0,d5
	addx.b	d6,d0
	move	ccr,d3
	ENDM

FlagROL	Macro
	move.w	d3,d5
	lsr.b	d5
	roxl.b	\1
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagROR Macro
	move.w	d3,d5
	lsr.b	d5
	roxr.b	\1
	move	ccr,d5
	and.w	#13,d5
	and.w	#2,d3
	or.b	d5,d3
	ENDM

FlagLSR	Macro
	move	ccr,d5
	and.w	#2,d3
	and.w	#5,d5
	or.b	d5,d3
	ENDM

	cnop	0,4

Rts:
	move.w	1(a3),d6
	ror.w	#8,d6
	move.l	d6,a4
	addq.w	#2,a3
	addq.w	#1,a4
	jmp	Start2
	
	cnop	0,4

Brk:
	jmp	Freak

	cnop	0,4

orax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

ascii:
	jmp	Freak

	cnop	0,4

oraz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

aslz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	FlagCNZ
	move.b	d6,(a0)
;	move.l	a2,a1		; setup write check
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

php:
	lea	ACTable,a1
	PackA
	move.b	(a1,d7),(a3)
	subq.w	#1,a3
	jmp	Start2

	cnop	0,4

orah:
	or.b	(a4)+,d0
	FlagNZ
	jmp	Start2

	cnop	0,4

asla:
	lsl.b	d0
	FlagCNZ
	jmp	Start2

	cnop	0,4

ora:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

asl:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	FlagCNZ
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

bpl:
	move.b	(a4)+,d6
	btst	#3,d3
	bne.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

oray:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

orax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

aslx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	FlagCNZ
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

clc:
	bclr	#0,d3
	jmp	Start2

	cnop	0,4

oray1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

orax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	or.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

aslx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	FlagCNZ
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2
	
	cnop	0,4

jsr:
	move.w	(a4),d6
	ror.w	#8,d6
	addq.w	#1,a4
	move.w	a4,d5
	ror.w	#8,d5
	move.w	d5,(-1,a3)
	subq.w	#2,a3
	move.l	d6,a4
	jmp	Start2

	cnop	0,4

andx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

bitz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	move.b	d6,d5
	and.b	#1,d3

	asr.b	#5,d5
	and.w	#10,d5
	and.b	d0,d6
	move	ccr,d6
	or.b	d6,d5
	or.b	d5,d3

;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

andz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

rolz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

plp:
	addq.w	#1,a3
	moveq	#0,d3
	move.b	(a3),d3
	lea	CATable,a1
	move.b	(a1,d3),d3
	UnPackA
	jmp	Start2
	cnop	0,4

andh:
	and.b	(a4)+,d0
	FlagNZ
	jmp	start2

	cnop	0,4

rola:
	FlagROL	d0
	jmp	Start2

	cnop	0,4

bit:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	move.b	d6,d5
	and.b	#1,d3

	asr.b	#5,d5
	and.w	#10,d5
	and.b	d0,d6
	move	ccr,d6
	or.b	d6,d5
	or.b	d5,d3

	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

and:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

rol:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

bmi:
	move.b	(a4)+,d6
	btst	#3,d3
	beq.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

andy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck
	
	cnop	0,4

andx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

rolx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

sec:
	bset	#0,d3
	jmp	Start2

	cnop	0,4

andy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

andx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	and.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

rolx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROL	d6
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

rti:
	addq.w	#1,a3
	moveq	#0,d3
	move.b	(a3)+,d3
	lea	CATable,a1
	move.b	(a1,d3),d3
	UnPackA
	move.w	(a3)+,d6
	ror.w	#8,d6
	move.l	d6,a4
	subq.w	#1,a3
	jmp	start2

	cnop	0,4

eorx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

eorz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

lsrz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

pha:
	move.b	d0,(a3)
	subq.w	#1,a3
	jmp	Start2

	cnop	0,4

eorh:
	move.b	(a4)+,d6
	eor.b	d6,d0
	FlagNZ
	jmp	Start2

	cnop	0,4

lsra:
	lsr.b	d0
	FlagLSR
	jmp	Start2

	cnop	0,4

jmp:
	move.w	(a4),d6
	ror.w	#8,d6
	move.l	d6,a4
	jmp	start2

	cnop	0,4

eor:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

lsr:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2
	
	cnop	0,4

bvc:
	move.b	(a4)+,d6
	btst	#1,d3
	bne.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

eory:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

eorx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

lsrx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

cli:
	bclr	#16,d3
	jmp	Start2

	cnop	0,4

eory1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

eorx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	eor.b	d6,d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

lsrx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	FlagLSR
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

adcx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

adcz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

rorz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

pla:
	addq.w	#1,a3
	move.b	(a3),d0
	FlagNZ
	jmp	Start2

	cnop	0,4

adch:
	move.b	(a4)+,d6
	FlagADD
	jmp	Start2
	
	cnop	0,4

rora:
	FlagROR	d0
	jmp	Start2

	cnop	0,4

jmpi:
	move.w	(a4),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a4
	jmp	Start2

	cnop	0,4

adc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

ror:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

bvs:
	move.b	(a4)+,d6
	btst	#1,d3
	beq.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

adcy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

adcx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

rorx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	Start2

	cnop	0,4

sei:
	bset	#16,d3
	jmp	Start2

	cnop	0,4

adcy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

adcx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagADD
	lea	1024(a2),a1
	jmp	RWCheck2
	
	cnop	0,4

rorx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagROR	d6
	move.b	d6,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

stax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.l	a2,a1
	jmp	RWCheck

	cnop	0,4

styz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d2,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

staz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d0,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

stxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	d1,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

dey:
	subq.b	#1,d2
	FlagNZ
	jmp	Start2

	cnop	0,4

txa:
	move.b	d1,d0
	FlagNZ
	jmp	Start2

	cnop	0,4

sty:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d2,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

sta:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

stx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	d1,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

bcc:
	move.b	(a4)+,d6
	btst	#0,d3
	bne.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

stay:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.l	a2,a1
	jmp	RWCheck

	cnop	0,4

styx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d2,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

stax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d0,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

stxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	d1,(a0)
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

tya:
	move.b	d2,d0
	FlagNZ
	jmp	Start2

	cnop	0,4

stay1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

txs:
	move.w	d1,a3
	add.w	#256,a3
	add.l	address,a3
	jmp	Start2

	cnop	0,4

stax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	d0,(a0)
	move.l	a2,a1
	jmp	RWCheck2
	
	cnop	0,4

Ldyh:
	move.b	(a4)+,d2
	FlagNZ
	jmp	Start2

	cnop	0,4

ldax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

Ldxh:
	move.b	(a4)+,d1
	FlagNZ
	jmp	Start2

	cnop	0,4

ldyz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

ldaz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

ldxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

tay:
	move.b	d0,d2
	FlagNZ
	jmp	Start2
	
	cnop	0,4
		
Ldah:
	move.b	(a4)+,d0
	FlagNZ
	jmp	Start2

	cnop	0,4

tax:
	move.b	d0,d1
	FlagNZ
	jmp	Start2

	cnop	0,4

ldy:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2
	
	cnop	0,4

lda:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

ldx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

bcs:
	move.b	(a4)+,d6
	btst	#0,d3
	beq.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

lday:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

ldyx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

ldax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

ldxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

clv:
	bclr	#1,d3
	jmp	Start2

	cnop	0,4

lday1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

tsx:
	move.w	a3,d1
	sub.w	#256,d1
	FlagNZ
	jmp	Start2

	cnop	0,4

ldyx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d2
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

ldax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d0
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

ldxy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d1
	FlagNZ
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

cpyh:
	cmp.b	(a4)+,d2
	FlagCMP
	jmp	Start2

	cnop	0,4

cmpx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck
	
	cnop	0,4

cpyz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d2
	FlagCMP
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

cmpz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

decz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

iny:
	addq.b	#1,d2
	FlagNZ
	jmp	Start2

	cnop	0,4

cmph:
	cmp.b	(a4)+,d0
	FlagCMP
	jmp	Start2

	cnop	0,4

dex:
	subq.b	#1,d1
	FlagNZ
	jmp	Start2

	cnop	0,4

cpy:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d2
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

cmp:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

dec:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

bne:
	move.b	(a4)+,d6
	btst	#2,d3
	bne.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

cmpy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

cmpx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

decx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

cld:
	bclr	#17,d3
	jmp	Start2

	cnop	0,4

cmpy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

cmpx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	cmp.b	(a0),d0
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

decx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	FlagNZ
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

cpxh:
	cmp.b	(a4)+,d1
	FlagCMP
	jmp	Start2

	cnop	0,4

sbcx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

cpxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	cmp.b	(a0),d1
	FlagCMP
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

sbcz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

incz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

inx:
	addq.b	#1,d1
	FlagNZ
	jmp	Start2

	cnop	0,4

sbch:
	move.b	(a4)+,d6
	FlagSUB
	jmp	Start2

	cnop	0,4

nop:
	jmp	Start2

	cnop	0,4

cpx:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	cmp.b	(a0),d1
	FlagCMP
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

sbc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

inc:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

beq:
	move.b	(a4)+,d6
	btst	#2,d3
	beq.w	Start2
	ext.w	d6
	add.w	d6,a4
	jmp	Start2

	cnop	0,4

sbcy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	lea	1024(a2),a1
	jmp	RWCheck

	cnop	0,4

sbcx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
;	lea	1024(a2),a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

incx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
;	move.l	a2,a1
;	jmp	RWCheck
	jmp	start2

	cnop	0,4

sed:
	bset	#17,d3
	jmp	Start2

	cnop	0,4

sbcy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

sbcx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	FlagSUB
	lea	1024(a2),a1
	jmp	RWCheck2

	cnop	0,4

incx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	FlagNZ
	move.l	a2,a1
	jmp	RWCheck2

	cnop	0,4

****	UN-IMPLEMENTED 6510 OP-CODES	*****
****	THESE WILL BE UNTESTED FOR A	*****
****	WHILE. SO DO NOT TRY TO USE	*****

slox:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

sloz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

anch:
	move.b	(a4)+,d6
	and.b	d6,d0
	lsl.b	d0
	FlagCNZ
	rts

slo:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

sloy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

slox1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

sloy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

slox1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsl.b	d6
	or.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

rlax:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

rlaz:
	sub.w	d6,d6
	move.w	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

anch2:
	move.b	(a4)+,d6
	and.b	d6,d0
	rol.b	d0
	FlagCNZ
	rts

rla:
	move.w	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	move.b	d6,(a0)
	move.w	#$ff,d7
	rts

rlay:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	rts

rlax1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

rlay1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

rlax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	rol.b	d6
	and.b	(a0),d0
	FlagNZ
	move.w	#$ff,d7
	move.b	d6,(a0)
	rts

srex:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	move.b	(a0),d5
	eor.b	d5,d0
	FlagNZ
	rts

srez:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	move.b	(a0),d5
	eor.b	d5,d0
	FlagNZ
	rts

asrh:
	move.b	(a4)+,d6
	and.b	d6,d0
	lsr.b	d0
	FlagNZ
	rts

sre:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	move.b	(a0),d5
	eor.b	d5,d0
	FlagNZ
	rts


srey:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	lsr.b	d6
	move.b	(a0),d5
	eor.b	d5,d0
	FlagNZ
	rts
	
srex1z:				;zeropage,x
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	move.b	d6,d5
	lsr.b	d6
	eor.b	d5,d0
	FlagNZ
	rts

srey1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	move.b	d6,d5
	lsr.b	d6
	eor.b	d5,d0
	FlagNZ
	rts
		
srex1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	move.b	d6,d5
	lsr.b	d6
	eor.b	d5,d0
	FlagNZ
	rts

rrax:
	move.w	d1,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

rraz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

arrh:
	sub.w	d6,d6
	move.b	(a4)+,d6
	and.b	d6,d0
	ror.b	d0
	FlagNZ
	rts

rra:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

rray:					;index indirect y ->(i,y)
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

rrax1z:					;z,x
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

rray1:					;absoloute y index
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

rrax1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.b	(a0),d6
	ror.b	d6
	add.b	d6,d0
	FlagADD
	rts

saxx:					;VERY weird
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	rts

saxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	rts

aneh:
	move.w	d1,d6
	and.b	(a4)+,d6
	and.b	#1,d0
	and.b	d6,d0
	rts

sax:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	rts

shay:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	and.w	#$21,d6
	move.b	d6,(a0)	
	rts

saxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.b	d6,(a0)
	rts

shsy1:				;ABSOLUTLY WEIRD!!!!
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	move.l	d6,a3
	and.b	#$21,d6
	move.b	d6,(a0)
	rts

shyx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	and.b	#$21,d6
	move.b	d6,(a0)
	rts

shxy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	and.b	#$21,d6
	move.b	d6,(a0)
	rts

shay1:				;huh? look @ one above me!
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.w	d0,d6
	and.w	d1,d6
	and.b	#$21,d6
	move.b	d6,(a0)
	rts

laxx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	rts

laxz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	rts

laxh:
	move.b	(a4)+,d0
	move.b	d0,d1
	FlagNZ
	rts

lax:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	rts

laxy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	rts

laxy1z:
	move.w	d2,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	rts

lasy1:				;WEIRD!
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.l	a3,d6
	and.w	#$ff,d6
	and.b	(a0),d6
	move.b	d6,d0
	move.b	d6,d1
	move.l	d6,a3
	rts

laxy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	move.b	(a0),d0
	move.b	d0,d1
	FlagNZ
	rts

dcpx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

dcpz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

sbxh:
	and.w	d0,d1
	sub.b	(a4)+,d1
	FlagSUB
	rts

dcp:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

dcpy:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

dcpx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

dcpy1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

dcpx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	subq.b	#1,(a0)
	cmp.b	(a0),d0
	FlagCMP
	rts

isbx:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

isbz:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

sbch2:
	move.b	(a4)+,d6
	FlagSUB
	rts

isb:
	move.w	(a4)+,d6
	ror.w	#8,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

isby:
	sub.w	d6,d6
	move.b	(a4)+,d6
	move.l	d6,a0
	move.w	(a0),d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

isbx1z:
	move.w	d1,d6
	add.b	(a4)+,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

isby1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d2,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

isbx1:
	move.w	(a4)+,d6
	ror.w	#8,d6
	add.w	d1,d6
	move.l	d6,a0
	addq.b	#1,(a0)
	move.b	(a0),d6
	FlagSUB
	rts

	cnop	0,4

UCopAddy:
	dc.l	0
InputEF:
	dc.l	0,0
	dc.b	2,52
	dc.l	InputName
	dc.l	0,InputHandler

InputName:
	dc.b	"Test InputHandler",0
	even
MySig:
	dc.l	0

MyTask:
	dc.l	0

idevname:	dc.b	'input.device',0
		cnop	0,4
InputEP:	dcb.b	34,0
		cnop	0,4
IEIOReq:	dcb.b	48,0

		cnop	0,4
CROMAddy:	dc.l	0
StackSave:	dc.l	0
BM1Addy:	dc.l	0
consolname:	dc.b	'CON:0/100/640/100/Debug',0
		even
conhandle:	dc.l	0
		
dosname:	dc.b	'dos.library',0
		even
dosbase:	dc.l	0

intuname:	dc.b	'intuition.library',0
		even
intbase:	dc.l	0

gfxname:	dc.b	'graphics.library',0
		even
gfxbase:	dc.l	0

RTname:		dc.b	'reqtools.library',0
		even
RTbase:		dc.l	0

Freq:		dc.l	0

locksav:	dc.l	0

windowhd:	dc.l	0

filehd:		dc.l	0

test:		dc.l	0

RTitle:		dc.b	'Select A File',0

kernel:		dc.b	'42Emu:64KernelROM',0

basic:		dc.b	'42Emu:64BasicROM',0

char:		dc.b	'42Emu:64CharROM',0

errmsg:		dc.b	"I/O Error!",0
		even
address:	dc.l	0

taskpt:		dc.l	0

taskoldwin:	dc.l	0

areg:		dc.l	0
xreg:		dc.l	0
yreg:		dc.l	0
sreg:		dc.l	0
stackp:		dc.l	0
progc:		dc.l	0
loadaddr:	dc.l	0
filelen:	dc.l	0

linef:		dc.b	10,13

buffer:		dcb.b	10,0
		even
buffer2:	dcb.b	256,0

inbuff:		dcb.b	128,0

		cnop	0,4
fileinfo:	dcb.b	256,0

		cnop	0,4

dir64:		dc.b	"42Emu:",0

		cnop	0,4
pat64:		dc.b	"E42.#?",0
		cnop	0,4

RRepeat:	dc.l	0	; defines repeated read True/False
		
myreqtag:	dc.l $80000032,dir64	; RTFI_Dir
		dc.l $80000033,pat64	; RTFI_MatchPat
		dc.l 0,0
freqtags:	dc.l $80000028,$10	; Give patternmatch gadget
		dc.l 0,0

BPL1Address:
		dc.l	0
BPL2Address:
		dc.l	0
BPL3Address:
		dc.l	0
BPL4Address:
		dc.l	0

JoyTable:
		dc.b	15
		dc.b	13	;down
		dc.b	5	;down-right
		dc.b	7	;right
		dc.b	14	;up
		dc.b	15
		dc.b	15
		dc.b	6	;up-right
		dc.b	10	;up-left
		dc.b	15
		dc.b	15
		dc.b	15
		dc.b	11	;left
		dc.b	9	;down-left
		dc.b	15
		dc.b	15

screen_defs:
		dc.w	0
		dc.w	-12
		dc.w	320
		dc.w	200
		dc.w	0		;no of bpls
		dc.b	17		;colour of text
		dc.b	16		;bkgrnd colour
		dc.w	$4000
		dc.w	256
		dc.l	0
		dc.l	screenname
		dc.l	0
		dc.l	0

window_defs:
		dc.w	0,0
		dc.w	320,200
		dc.b	17,16
		dc.l	0
		dc.l	$11900		;flags
		dc.l	0
		dc.l	0
		dc.l	0
screenhd:	dc.l	0
		dc.l	0
		dc.w	320,200
		dc.w	320,200
		dc.w	15

screenname:	dc.b	'64 Emulator',0
		even
colour64:
; 0 - 15
		dcb.w	16,0		;16 blacks
; 16 -31
Palette:	dc.w	$0000		;black
		dc.w	$0fff		;white
		dc.w	$0c34		;red
		dc.w	$03dc		;cyan
		dc.w	$0b6d		;purple
		dc.w	$05c5		;green
		dc.w	$045f		;blue
		dc.w	$0ef7		;yellow
		dc.w	$0d84		;orange
		dc.w	$0964		;brown
		dc.w	$0f99		;lt red
		dc.w	$0666		;grey1
		dc.w	$0999		;grey2
		dc.w	$09fa		;lt green
		dc.w	$078f		;lt blue
		dc.w	$0ccc		;grey3

KeyWSt:	dc.b	0,0

KeyBank:
	dc.w	0
KeySema:
	dc.l	0
KeyBuffer:
	dc.l	-1
	dc.l	-1
	
	include	KeyQualTable.inc

KeyMapTable:
	include	KeyMap.s

	cnop	0,4
	dcb.l	1024,0		; our stack area
table:
	dc.l	Brk
	dc.l	orax
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	oraz
	dc.l	aslz
	dc.l	ascii
	dc.l	php
	dc.l	orah
	dc.l	asla
	dc.l	ascii
	dc.l	ascii
	dc.l	ora
	dc.l	asl
	dc.l	ascii
	dc.l	bpl
	dc.l	oray
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	orax1z
	dc.l	aslx1z
	dc.l	ascii
	dc.l	clc
	dc.l	oray1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	orax1
	dc.l	aslx1
	dc.l	ascii
	dc.l	jsr
	dc.l	andx
	dc.l	ascii
	dc.l	ascii
	dc.l	bitz
	dc.l	andz
	dc.l	rolz
	dc.l	ascii
	dc.l	plp
	dc.l	andh
	dc.l	rola
	dc.l	ascii
	dc.l	bit
	dc.l	and
	dc.l	rol
	dc.l	ascii
	dc.l	bmi
	dc.l	andy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	andx1z
	dc.l	rolx1z
	dc.l	ascii
	dc.l	sec
	dc.l	andy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	andx1
	dc.l	rolx1
	dc.l	ascii
	dc.l	rti
	dc.l	eorx
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	eorz
	dc.l	lsrz
	dc.l	ascii
	dc.l	pha
	dc.l	eorh
	dc.l	lsra
	dc.l	ascii
	dc.l	jmp
	dc.l	eor
	dc.l	lsr
	dc.l	ascii
	dc.l	bvc
	dc.l	eory
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	eorx1z
	dc.l	lsrx1z
	dc.l	ascii
	dc.l	cli
	dc.l	eory1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	eorx1
	dc.l	lsrx1
	dc.l	ascii
	dc.l	rts
	dc.l	adcx
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	adcz
	dc.l	rorz
	dc.l	ascii
	dc.l	pla
	dc.l	adch
	dc.l	rora
	dc.l	ascii
	dc.l	jmpi
	dc.l	adc
	dc.l	ror
	dc.l	ascii
	dc.l	bvs
	dc.l	adcy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	adcx1z
	dc.l	rorx1z
	dc.l	ascii
	dc.l	sei
	dc.l	adcy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	adcx1
	dc.l	rorx1
	dc.l	ascii
	dc.l	ascii
	dc.l	stax
	dc.l	ascii
	dc.l	ascii
	dc.l	styz
	dc.l	staz	;133
	dc.l	stxz
	dc.l	ascii
	dc.l	dey
	dc.l	ascii
	dc.l	txa	;138
	dc.l	ascii
	dc.l	sty
	dc.l	sta
	dc.l	stx
	dc.l	ascii
	dc.l	bcc
	dc.l	stay
	dc.l	ascii
	dc.l	ascii
	dc.l	styx1z
	dc.l	stax1z
	dc.l	stxy1z
	dc.l	ascii
	dc.l	tya
	dc.l	stay1
	dc.l	txs
	dc.l	ascii
	dc.l	ascii
	dc.l	stax1
	dc.l	ascii
	dc.l	ascii
	dc.l	ldyh
	dc.l	ldax
	dc.l	ldxh
	dc.l	ascii
	dc.l	ldyz
	dc.l	ldaz	;165
	dc.l	ldxz
	dc.l	ascii
	dc.l	tay
	dc.l	ldah
	dc.l	tax
	dc.l	ascii
	dc.l	ldy
	dc.l	lda
	dc.l	ldx
	dc.l	ascii
	dc.l	bcs
	dc.l	lday
	dc.l	ascii
	dc.l	ascii
	dc.l	ldyx1z
	dc.l	ldax1z
	dc.l	ldxy1z
	dc.l	ascii
	dc.l	clv
	dc.l	lday1
	dc.l	tsx
	dc.l	ascii
	dc.l	ldyx1
	dc.l	ldax1
	dc.l	ldxy1
	dc.l	ascii
	dc.l	cpyh
	dc.l	cmpx
	dc.l	ascii
	dc.l	ascii
	dc.l	cpyz
	dc.l	cmpz
	dc.l	decz
	dc.l	ascii
	dc.l	iny
	dc.l	cmph
	dc.l	dex
	dc.l	ascii
	dc.l	cpy
	dc.l	cmp
	dc.l	dec
	dc.l	ascii
	dc.l	bne
	dc.l	cmpy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	cmpx1z
	dc.l	decx1z
	dc.l	ascii
	dc.l	cld
	dc.l	cmpy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	cmpx1
	dc.l	decx1
	dc.l	ascii
	dc.l	cpxh
	dc.l	sbcx
	dc.l	ascii
	dc.l	ascii
	dc.l	cpxz
	dc.l	sbcz
	dc.l	incz
	dc.l	ascii
	dc.l	inx	;232
	dc.l	sbch
	dc.l	nop
	dc.l	ascii
	dc.l	cpx
	dc.l	sbc
	dc.l	inc
	dc.l	ascii
	dc.l	beq	;240
	dc.l	sbcy
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	sbcx1z
	dc.l	incx1z
	dc.l	ascii
	dc.l	sed
	dc.l	sbcy1
	dc.l	ascii
	dc.l	ascii
	dc.l	ascii
	dc.l	sbcx1
	dc.l	incx1
	dc.l	ascii

counter:
	dc.l	0
counter2:
	dc.l	0

	include	ACTable.s

	cnop	0,4

COP_IS:
	dc.l	0,0
	dc.b	2,0			;type,priority 2=interrupt
	dc.l	CName
	dc.l	ISData,ISInterrupt
CName:	dc.b	"42-Interrupt",0
	even
ISData:	dc.l	0
	cnop	0,4

WriteBase:
	dc.l	start2		; 0
	dc.l	KROMS		; 1
	dc.l	RasterW		; 2
	dc.l	BROMS		; 3
	dc.l	DoScreen0	; 4
	dc.l	DoScreen1	; 5
	dc.l	BorderCol	; 6
	dc.l	ScreenCol	; 7
	dc.l	KeyWrite	; 8
	dc.l	start2
	dc.l	ColWrite
	dc.l	VCRW2		;11
	dc.l	Sprite0P	;12
	dc.l	Sprite1P
	dc.l	Sprite2P
	dc.l	Sprite3P
	dc.l	Sprite4P
	dc.l	Sprite5P
	dc.l	Sprite6P
	dc.l	Sprite7P	;19
	dc.l	SpriteEN	;20
	dc.l	SpriteMSBX	;21
	dc.l	Sprite0X	;22
	dc.l	Sprite0Y
	dc.l	Sprite1X
	dc.l	Sprite1Y
	dc.l	Sprite2X
	dc.l	Sprite2Y
	dc.l	Sprite3X
	dc.l	Sprite3Y
	dc.l	Sprite4X
	dc.l	Sprite4Y
	dc.l	Sprite5X
	dc.l	Sprite5Y
	dc.l	Sprite6X
	dc.l	Sprite6Y
	dc.l	Sprite7X
	dc.l	Sprite7Y
	dc.l	Sprite0C	;38
	dc.l	Sprite1C
	dc.l	Sprite2C
	dc.l	Sprite3C
	dc.l	Sprite4C
	dc.l	Sprite5C
	dc.l	Sprite6C
	dc.l	Sprite7C	;45
	dc.l	SpriteMCM	;46
	dc.l	SpriteMC0	;47
	dc.l	SpriteMC1	;48
	dc.l	SpriteXX	;49
	dc.l	SpriteYY	;50
	dc.l	VCRW1		;51
	dc.l	ScreenCol1	;52
	dc.l	ScreenCol2	;53
	dc.l	ScreenCol3	;54
	dc.l	MCR		;55
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2

ReadBase:
	dc.l	start2		; 0
	dc.l	start2		; 1
	dc.l	RasterR		; 2
	dc.l	Start2
	dc.l	Start2
	dc.l	Start2
	dc.l	Start2
	dc.l	Start2
	dc.l	ReadJOY2	; 8
	dc.l	KeyRead		; 9
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	dc.l	start2
	
ScrLUT:	dcb.l	1000,0

ColLUT:	dcb.l	1000,0

ECM:
	dc.b	0
MCM:
	dc.b	0

Sprite0MSB:
	dc.w	0
Sprite1MSB:
	dc.w	0
Sprite2MSB:
	dc.w	0
Sprite3MSB:
	dc.w	0
Sprite4MSB:
	dc.w	0
Sprite5MSB:
	dc.w	0
Sprite6MSB:
	dc.w	0
Sprite7MSB:
	dc.w	0

Sprite0MC:
	dc.b	0
Sprite1MC:
	dc.b	0
Sprite2MC:
	dc.b	0
Sprite3MC:
	dc.b	0
Sprite4MC:
	dc.b	0
Sprite5MC:
	dc.b	0
Sprite6MC:
	dc.b	0
Sprite7MC:
	dc.b	0

Sprite0A:
	dc.b	0
Sprite1A:
	dc.b	0
Sprite2A:
	dc.b	0
Sprite3A:
	dc.b	0
Sprite4A:
	dc.b	0
Sprite5A:
	dc.b	0
Sprite6A:
	dc.b	0
Sprite7A:
	dc.b	0

Sprite0PT:
	dc.b	0
Sprite1PT:
	dc.b	0
Sprite2PT:
	dc.b	0
Sprite3PT:
	dc.b	0
Sprite4PT:
	dc.b	0
Sprite5PT:
	dc.b	0
Sprite6PT:
	dc.b	0
Sprite7PT:
	dc.b	0

Sprite0XX:
	dc.b	0
Sprite1XX:
	dc.b	0
Sprite2XX:
	dc.b	0
Sprite3XX:
	dc.b	0
Sprite4XX:
	dc.b	0
Sprite5XX:
	dc.b	0
Sprite6XX:
	dc.b	0
Sprite7XX:
	dc.b	0

Sprite0YY:
	dc.b	0
Sprite1YY:
	dc.b	0
Sprite2YY:
	dc.b	0
Sprite3YY:
	dc.b	0
Sprite4YY:
	dc.b	0
Sprite5YY:
	dc.b	0
Sprite6YY:
	dc.b	0
Sprite7YY:
	dc.b	0

data:
	incbin	data.inc
expand:
	incbin	expand.inc
multi:
	incbin	multi.inc

	Section	Copper,Data_C
	
BlitCharSet:
	incbin	blitchar.inc

	cnop	0,8

Sprite0:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite1:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite2:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite3:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite4:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite5:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite6:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
Sprite7:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0
NullSprite:
	dc.l	0,0,0,0
	dcb.l	176,0
	dc.l	0,0,0,0

MyCopList:
	wait	0,20

	dc.w	color00,$0000
	dc.w	color01,$0000
MultiC:
	dc.w	color05,$0000
	dc.w	color07,$0000
	dc.w	color09,$0000
	dc.w	color13,$0000

SColour1:
	dc.w	color17,$0000		;odd
	dc.w	color21,$0000
	dc.w	color25,$0000
	dc.w	color29,$0000

Mcolour1:
	dc.w	color18,$0000
	dc.w	color19,$0000
	dc.w	color22,$0000
	dc.w	color23,$0000
	dc.w	color26,$0000
	dc.w	color27,$0000
	dc.w	color30,$0000
	dc.w	color31,$0000

	dc.w	bplcon4,$0031
	dc.w	diwstrt,$3081
	dc.w	bplcon0,$4200
	dc.w	bplcon2,$0224
	dc.w	bplcon3,$0c40
	dc.w	diwstop,$f8c1
	dc.w	ddfstrt,$0038
	dc.w	ddfstop,$00d0
	dc.w	bplcon1,$0000
	dc.w	bpl1mod,$0070
	dc.w	bpl2mod,$0070

Screen:
	dc.w	bpl1pth,$0000
	dc.w	bpl1ptl,$0000

	dc.w	bpl2pth,$0000
	dc.w	bpl2ptl,$0000

	dc.w	bpl3pth,$0000
	dc.w	bpl3ptl,$0000

	dc.w	bpl4pth,$0000
	dc.w	bpl4ptl,$0000

CSprite:
	dc.w	spr0pth,$0000,spr0ptl,$0000
	dc.w	spr1pth,$0000,spr1ptl,$0000
	dc.w	spr2pth,$0000,spr2ptl,$0000
	dc.w	spr3pth,$0000,spr3ptl,$0000

	dc.w	spr4pth,$0000,spr4ptl,$0000
	dc.w	spr5pth,$0000,spr5ptl,$0000
	dc.w	spr6pth,$0000,spr6ptl,$0000
	dc.w	spr7pth,$0000,spr7ptl,$0000

	dc.w	fmode,$000f

NewCopper:
	incbin copper.inc

CopLEnd:
	wait	$ff,$fe			; End of Coplist
	cnop	0,4

